<?php $this->load->view('admin/comman/header');?>

<div class="clearfix"></div>
<div class="content-wrapper">
    <div class="container-fluid">
        <!-- Breadcrumb-->
        <div class="row pt-2 pb-2">
            <div class="col-sm-9">
                <h4 class="page-title">Add Magazine</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/dashboard">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/magazine">Magazine</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Add</li>
                </ol>
            </div>
        </div>
        <!-- End Breadcrumb-->
        <div class="row">
            <div class="col-lg-12 mx-auto">
                <div class="card">
                    <div class="card-body">
                        <form id="edit_video_form" enctype="multipart/form-data">
                            <div class="row col-lg-12">
                                <div class="form-group col-lg-6">
                                    <label for="input-1"> Name</label>
                                    <input type="text" required value="" class="form-control" name="title" id="title">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="category_id"> Category</label>
                                    <select name="category_id" id="category_id" required class="form-control">
                                        <option value="">Select Category</option>
                                        <?php foreach ($categorylist as $cat) {?>
                                        <option required value="<?php echo $cat->id; ?>"><?php echo $cat->name; ?>
                                        </option>
                                        <?php }?>
                                    </select>
                                </div>
                            </div>

                            <div class="row col-lg-12">
                                <div class="form-group col-lg-6">
                                    <label for="is_paid"> Cost</label>
                                    <select name="is_paid" required class="form-control" id="purpose">
                                        <option value="0">Free</option>
                                        <option value="1">Paid</option>
                                    </select>
                                </div>
                                <div id="business" style="display:none" class="form-group col-lg-6">
                                    <div>
                                        <label for="input-1"> price</label>
                                        <input type="text" required value="" class="form-control" name="price"
                                            id="price" placeholder="Enter magazine Price">
                                    </div>

                                </div>
                            </div>
                            <div class="row col-lg-12">
                                <div class="form-group col-lg-12">
                                    <?php if ($_SESSION['role_id'] == 1) {?>
                                    <label for="input-2"> Author</label>
                                    <!-- DropDown -->
                                    <select name="author_id" required class="form-control">
                                        <option value="">Select Author</option>
                                        <?php foreach ($authorlist as $cat) {?>
                                        <option value="<?php echo $cat->id; ?>"><?php echo $cat->name; ?></option>
                                        <?php }?>
                                    </select>
                                    <?php } else {?>
                                    <input type="hidden" name="author_id" value="<?php echo $_SESSION['id']; ?>">
                                    <?php }?>
                                </div>
                            </div>

                            <div class="row col-lg-12">
                                <div class="form-group col-lg-12">
                                    <label for="input-1"> Description</label>
                                    <textarea class="form-control summernote" name="description"
                                        id="description"></textarea>
                                </div>

                            </div>
                            <div class="row col-lg-12">
                                <div class="form-group col-lg-6">
                                    <label for="input-1"> Upload Sample </label>
                                    <input type="file" required class="form-control" name="sample_url" id="sample_url"
                                        placeholder="select Sample magazine">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="input-1"> Cover Poster</label>
                                    <input type="file" required class="form-control" name="image" id="image"
                                        onchange="readURL(this,'showImage')">
                                    <p class="noteMsg">Note: Image Size must be less than 2MB.Image Height and Width
                                        less than 1000px.</p>
                                    <img id="showImage"
                                        src="<?php echo base_url() . 'assets/images/placeholder.png'; ?>" height="100"
                                        width="100" alt="your image" />
                                </div>
                            </div>
                            <div class="row col-lg-12">
                                <div class="form-group col-lg-6">
                                    <label for="input-1">Upload Full </label>
                                    <div id="filelist">Your browser doesn't have Flashs, Silverlight or HTML5
                                        support.
                                    </div>
                                    <div id="container">
                                        <div class="form-group">
                                            <input type="file" id="uploadFile" name="uploadFile">
                                        </div>
                                        <input type="hidden" name="mp3_file_name" id="mp3_file_name" value=""
                                            class="form-control">
                                        <div class="form-group">
                                            <a id="upload" href="javascript:" class="btn btn-danger">Upload
                                                files</a>
                                        </div>
                                    </div>
                                    <input type="hidden" id="file_ext" name="file_ext"
                                        value="<?=substr(md5(rand(10, 100)), 0, 10)?>">
                                    <div id="console"></div>
                                </div>
                            </div>
                            <div class="row col-lg-12">
                                <div class="form-group col-lg-12">
                                    <button type="button" onclick="savemagazine()"
                                        class="btn btn-primary shadow-primary px-5">Save</button>
                                    <a href="<?php echo base_url(); ?>admin/magazine"
                                        class="border-primary btn btn-default px-5 ">Cancel
                                    </a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$this->load->view('admin/comman/footerpage');
?>
<script type="text/javascript">
$('#purpose').on('change', function() {
    if (this.value === '1') {
        $("#business").show();
    } else {
        $("#business").hide();
    }
});

function savemagazine() {

    $("#dvloader").show();
    var formData = new FormData($("#edit_video_form")[0]);

    var textareaValue = $('#description').code();
    formData.append("description", textareaValue);


    $.ajax({
        type: 'POST',
        url: '<?php echo base_url(); ?>admin/magazine/save',
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function(resp) {
            $("#dvloader").hide();
            if (resp.status == '200') {
                document.getElementById("edit_video_form").reset();
                toastr.success(resp.message, 'success');
                setTimeout(function() {
                    window.location.replace('<?php echo base_url(); ?>admin/magazine');
                }, 500);
            } else {
                var obj = resp.message;
                if (typeof obj === 'string') {
                    toastr.error(obj);
                } else {
                    $.each(obj, function(i, e) {
                        toastr.error(e);
                    });
                }
            }
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
            $("#dvloader").hide();
            toastr.error(errorThrown.msg, 'failed');
        }
    });
}
</script>