<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Coupon extends CI_Controller{

	public function __construct() {
		parent::__construct();
		$CI =& get_instance();
		frontendcheck();
	}

	public function index(){
		$this->load->view("admin/coupon/list");
	}

	public function add(){
		$this->load->view("admin/coupon/add");
	}

	public function save(){
		$this->form_validation->set_rules('coupon_code', 'coupon code', 'required');
        $this->form_validation->set_rules('start_date', 'start_date', 'required');
        $this->form_validation->set_rules('end_date', 'end date', 'required');
        $this->form_validation->set_rules('type', 'type', 'required');
        $this->form_validation->set_rules('price', 'type', 'required');
        if ($this->form_validation->run() == FALSE)
        {
            $errors = validation_errors();
			$array  = array('status'=>400,'message'=>$errors);
         	echo json_encode($array);exit;
        }
        else
        {
			$coupon_code = $_POST['coupon_code'];
			$description = isset($_POST['description']) ? $_POST['description'] : '';
			$start_date = $_POST['start_date'];
			$end_date = $_POST['end_date'];
			$type = $_POST['type'];
			$price = $_POST['price'];

			$where='coupon_code="'.$coupon_code.'"';
			$coupon = $this->CRUD_model->get($where,'coupon');

			if(sizeof($coupon)>0){
				$res=array('status'=>'400','message'=>'coupon code is already exists.');
				echo json_encode($res);exit;	
			}

			$data = array(
				'coupon_code' => $coupon_code,
				'description' => $description,
				'start_date' => date('Y-m-d', strtotime($start_date)),
				'end_date' =>  date('Y-m-d', strtotime($end_date)),
				'type' => $type,
				'price' => $price,
			);
		
			$id=$this->CRUD_model->insert($data,'coupon');
			$res=array('status'=>'200','message'=>'Sucessfully updated','id'=>$id);
			echo json_encode($res);exit;
		}
	}

	public function edit(){
		$where='id="'.$_GET['id'].'"';
		$data['coupon'] = $this->CRUD_model->getById($where,'coupon');

		$this->load->view("admin/coupon/edit",$data);
	}

	public function update(){
		$this->form_validation->set_rules('coupon_code', 'coupon code', 'required');
        $this->form_validation->set_rules('start_date', 'start_date', 'required');
        $this->form_validation->set_rules('end_date', 'end date', 'required');
        $this->form_validation->set_rules('type', 'type', 'required');
        $this->form_validation->set_rules('price', 'type', 'required');

        if ($this->form_validation->run() == FALSE)
        {
            $errors = validation_errors();
			$array  = array('status'=>400,'message'=>$errors);
         	echo json_encode($array);exit;
        }
        else
        {
        	$coupon_code = $_POST['coupon_code'];
			$description = isset($_POST['description']) ? $_POST['description'] : '';
			$start_date = $_POST['start_date'];
			$end_date = $_POST['end_date'];
			$type = $_POST['type'];
			$price = $_POST['price'];

			$data = array(
				'coupon_code' => $coupon_code,
				'description' => $description,
				'start_date' => date('Y-m-d', strtotime($start_date)),
				'end_date' =>  date('Y-m-d', strtotime($end_date)),
				'type' => $type,
				'price' => $price,
			);
			
			$cat_id=$this->CRUD_model->update($_POST['id'],'id',$data,'coupon');

			$res=array('status'=>'200','message'=>'Sucessfully updated','id'=>$cat_id);
			echo json_encode($res);exit;
		}
	}

	public function getcoupon()
	{
		$coupon = $this->CRUD_model->get('','coupon');
		$result = array('status'=>'200','message'=>'Get coupon Sucessfully','result'=>$coupon);
		echo json_encode($result);exit;
	}

	public function fetch_data(){  

    	$table = "coupon";
	  	$select_column = array("id","coupon_code","price","start_date","end_date", "created_at");  
	  	$order_column = array(null,"start_date","end_date", "price", "coupon_code", "created_at");  
	  	$search = array("coupon_code","start_date","end_date", "price", "created_at");

       	$fetch_data = $this->CRUD_model->make_datatables($table, $select_column,$order_column,$search);  
       	$data = array();  
       	foreach($fetch_data as $key=> $row)  
       	{  
            $sub_array = array();  
           	$sub_array[] = $key+1; 
            $sub_array[] = string_cut($row->coupon_code,15); 
            $sub_array[] = $row->price; 
            $sub_array[]  = dateformate($row->start_date);
            $sub_array[] = 	dateformate($row->end_date);
            $sub_array[] = '<a href="'.base_url().'admin/coupon/edit?id='.$row->id.'">Edit</a> | <a href="javaScript:void(0)" onclick="delete_record('.$row->id.',\'coupon\')">Delete</a>';
            $data[] = $sub_array;  
       	}
       	$output = array(  
            "draw"             => intval($_POST["draw"]),  
            "recordsTotal"     => $this->CRUD_model->get_all_data($table),  
            "recordsFiltered"  => $this->CRUD_model->get_filtered_data($table,$select_column,$order_column,$search=null),  
            "data"             => $data  
       	);  
       	echo json_encode($output);  
    }
}
