<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $CI = & get_instance();
        frontendcheck();
    }

    public function index() {

        if ($_SESSION['role_id'] == 2) {
            redirect('admin/Authorprofile/dashboard');
        }

        /* for Book Count */
        $result = $this->CRUD_model->get('', 'book');
        $data['books'] = sizeof($result);

        $magazine = $this->CRUD_model->get('', 'magazine');
        $data['magazine'] = sizeof($magazine);

        /* for category Count */
        $result = $this->CRUD_model->get('', 'category');
        $data['category'] = sizeof($result);

        /* Register User */
        $result = $this->CRUD_model->get('', 'user');
        $data['register_user'] = sizeof($result);

        $first_day = date("Y-m-d", strtotime('monday this week'));
        $row = [$first_day];
        for ($i = 1; $i <= 6; $i++) {
            $date = date("Y-m-d", strtotime('+' . $i . ' days', strtotime($first_day)));
            $row[$i] = $date;
        }

        $data_count = $dataAmountBook = $dataAmountMagazine = [];
        foreach ($row as $key => $value) {
            $whereUser = "created_at > '" . $value . " 00:00:00' AND created_at < '" . $value . " 23:59:59'";
            $total_user = $this->CRUD_model->getCountData($whereUser, 'user', '', 'count(id) as total_user');
            $data_count[] = $total_user->total_user;
            
            $whereBook = "created_at > '" . $value . " 00:00:00' AND created_at < '" . $value . " 23:59:59' AND book_id != 0";
            $total_book_earning = $this->CRUD_model->getCountData($whereBook, 'transaction', '', 'sum(amount) as total_amount');
            $dataAmountBook[] = $total_book_earning->total_amount;
            
            $whereMagazine = "created_at > '" . $value . " 00:00:00' AND created_at < '" . $value . " 23:59:59' AND magazine_id != 0";
            $total_Magazine_earning = $this->CRUD_model->getCountData($whereMagazine, 'transaction', '', 'sum(amount) as total_amount');
            $dataAmountMagazine[] = $total_Magazine_earning->total_amount;
        }
        

        $last_week_day = date("Y-m-d", strtotime('monday this week'));
        $rows = [$last_week_day];
        for ($i = 1; $i <= 6; $i++) {
            $new_date = date("Y-m-d", strtotime('+' . $i . ' days', strtotime($last_week_day)));
            $rows[$i] = $new_date;
        }

     
        $label =  $datas = [];
       
        $whereUser = "transaction.created_at > '" . $rows[0]. " 00:00:00' AND transaction.created_at < '" . $rows[6] . " 23:59:59'";
        $userResult = $this->CRUD_model->getCountDataOrderBy($whereUser, 'transaction', 'author_id', 'author_commission_amount,author.name','desc','author_commission_amount','10');
      
        foreach ($userResult as $key => $weekData) {
        	$label[] = $weekData->name;
        	$datas[] = $weekData->author_commission_amount;
        }
        
        $today = date('Y-m-d');
        
        $wheretoday = "created_at > '" . $today . " 00:00:00' AND created_at < '" . $today . " 23:59:59'";
        $today_earning = $this->CRUD_model->getCountData($wheretoday, 'transaction', '', 'sum(amount) as total_amount');
         
        $data['week_earning_data'] = $datas;
        $data['week_earning_label'] = $label;
      
        $data['today_earning'] = $today_earning->total_amount;
        $data['week_user'] = $data_count;
        $data['week_book_earning'] = $dataAmountBook;
        $data['week_magazine_earning'] = $dataAmountMagazine;
       
        /* Autohr */
        $where = 'role_id=2';
        $autohr = $this->CRUD_model->get($where, 'author');
        $data['autohr'] = sizeof($autohr);

        /* for category Count */
        $earning = $this->CRUD_model->getAdminAuthorEarning();
        $data['earning'] = $earning;
        $data['settinglist'] = get_setting();
        
        $this->load->view("admin/dashboard/dashboard", $data);
    }

}