<?php $this->load->view('admin/comman/header');?>

<div class="clearfix"></div>
<div class="content-wrapper">
    <div class="container-fluid">
        <!-- Breadcrumb-->
        <div class="row pt-2 pb-2">
            <div class="col-sm-9">
                <h4 class="page-title">Authors</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>admin/dashboard">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>admin/author">Authors</a></li>
                    <li class="breadcrumb-item active" aria-current="page">List</li>
                </ol>
            </div>
            <div class="col-sm-3">
                <div class="btn-group float-sm-right">
                    <a href="<?php echo base_url(); ?>admin/author/add"
                        class="btn btn-outline-primary waves-effect waves-light">Add</a>

                </div>
            </div>
        </div>
        <!-- End Breadcrumb-->
        <div class="">
            <div class="card">
                <div class="card-header"><i class="fa fa-table"></i> Author Record</div>
                <div class="card-body">
                    <div class="">
                        <table id="author-datatable" class="table-sm table-striped table-bordered" width="100%">
                            <thead class="badge-secondary">
                                <tr>
                                    <th>Image</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Author's Bio</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- End Row-->

    <?php
$this->load->view('admin/comman/footerpage');
?>

    <script>
    $(document).ready(function() {
        var dataTable = $('#author-datatable').DataTable({
            "processing": true,
            "serverSide": true,
            "order": [],
            "ajax": {
                url: "<?php echo base_url() . 'admin/author/fetch_data'; ?>",
                type: "POST"
            },
            "columnDefs": [{
                //  "targets":[0, 3, 4],
                "orderable": false,
            }, ],
        });
    });
    
    function update_status(id, status) {
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url(); ?>admin/author/statusUpdate',
            data: {
                'id': id,
                'status': status
            },
            success: function(resp) {
                var obj = JSON.parse(resp);
                var text = '';
                if (obj.book_status == '1') {

                    text =
                        ' <a style="color: #ffffff;"  href="#" onclick="update_status(' +
                        id + ',`' +
                        obj.book_status +
                        '`)"> <i class="fa fa-toggle-on blockquote-footer fa-2x"></i></a>';
                } else {
                    text =
                        '<a style="color: #ffffff;"  href="#" onclick="update_status(' +
                        id + ',`' +
                        obj.book_status +
                        '`)"> <i class="fa fa-toggle-off blockquote-footer fa-2x"></i></a>';
                }
                $('.active_' + id).html(text);
            }
        });
    }
    </script>