<?php $this->load->view('admin/comman/header');?>

<div class="clearfix"></div>
<div class="content-wrapper">
    <div class="container-fluid">
        <!-- Breadcrumb-->
        <div class="row pt-2 pb-2">
            <div class="col-sm-9">
                <h4 class="page-title">Wallet Transaction</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo base_url()?>admin/dashboard">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo base_url()?>admin/user">Users</a></li>
                    <li class="breadcrumb-item active">Wallet Transaction</li>
               </ol>
            </div>
            <div class="col-sm-3">
                <div class="btn-group float-sm-right">
                    <a href="<?php echo base_url();?>admin/users" class="btn btn-outline-primary waves-effect waves-light">User List</a>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-12 mx-auto">
                        <div class="card">
                            <div class="card-body">
                                <div class="card-title">Add Amount</div>
                                <hr>
                                <form id="user_form"  enctype="multipart/form-data">
                                    <div class="form-row mt-3">
                                        <div class="col-sm-6 ">
                                            <?php  $userid = isset($user_id) ? $user_id : '0'; ?>
                                            <label for="input-1">User</label>
                                            <select name="user_id" class="form-control" id="user_id">
                                                <option> Select User</option>
                                                <?php foreach ($user as $key => $value) {?>
                                                <option <?php if($value->id == $userid){ echo "selected"; } ?> value="<?php echo $value->id;?>"> <?php echo $value->fullname;?></option>    
                                                <?php } ?>
                                            </select>
                                        </div>
                                       <div class="col-sm-6 ">
                                            <label for="input-1">Amount</label>
                                            <input type="text" required value="" name="amount" class="form-control">
                                        </div>
                                    </div>
                                    <div class="form-row mt-3">
                                        <div class="col-sm-6 ">
                                            <button type="button" onclick="wallet_transfer()" class="btn btn-primary shadow-primary px-5">Save</button>
                                        </div>
                                    </div>        
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $this->load->view('admin/comman/footerpage');?>
<script type="text/javascript">
  function wallet_transfer(){

    displayLoader();
    var formData = new FormData($("#user_form")[0]);
    $.ajax({
        type:'POST',
        url:'<?php echo base_url(); ?>admin/users/add_wallet_transaction',
        data:formData,
        cache:false,
        contentType: false,
        processData: false,
        dataType: "json",
        success:function(resp){
        if(resp.status=='200'){
            hideLoader();
            document.getElementById("user_form").reset();
            toastr.success(resp.message,'success');                 
            setTimeout(function(){ 
                window.location.replace('<?php echo base_url(); ?>admin/users');
            }, 500);
        }else{
            hideLoader();
            var obj = resp.message;
            $.each(obj, function(i,e) {
                toastr.error(e);
            });
        }
      }
    });

  }

</script>